/*
 * D. A. Kapilow
 * Robotics Research Principles Department
 * AT&T Bell Laboratories
 * 600 Mountain Avenue
 * Murray Hill, N.J.  07974
 * 11/16/88
 *
 * Generic real-time and operating system kernel debug monitor
 */

/*
 * Format of a debug request
 */
struct DebugRequest {
	short	proc;		/* Processor id */
	short	id;		/* Process id */
	short	req;		/* Request */
	short	ack;		/* Acknowledgement */
	long	arg[3];		/* Arguments */
};
/*
 * Special id to debug kernel
 */
#define	DB_KERNELID	-1

/*
 * Debug Requests - encoded so that requests sending information
 * besides arguments always have bit 0x100 set 
 */
#define	DBR_PUTBIT	0x100
#define	DBR_NULL	0x000
#define	DBR_GETATTRIB	0x001	/* Determine processor, O.S, floating point */
#define	DBR_READ	0x002
#define	DBR_RUN		0x003	/* Start a stopped process */
#define	DBR_STOP	0x004	/* Halt a process */
#define	DBR_STEP	0x005	/* Step an assembler statement */
#define	DBR_GETSCRATCH	0x006	/* Get address of scratch area */
#define	DBR_KILL	0x007	/* Send a signal */
#define	DBR_GETSTATE	0x008	/* Retrun state of process - O.S. dependent */
#define	DBR_GETREGS	0x009	/* Registers */
#define	DBR_GETFPREGS	0x00A	/* Floating point registers */
#define	DBR_SETBKPT	0x00B	/* Place a breakpoint at a given address */
#define	DBR_GETSNAME	0x00C	/* File name of symbol table */
#define	DBR_GETBNAME	0x00D	/* Symbolic name of board */
#define	DBR_GETNPROC	0x00E	/* Number of processors */
#define	DBR_WRITE	0x100
#define	DBR_PUTREGS	0x101
#define	DBR_PUTFPREGS	0x102
#define	DBR_PUTSNAME	0x103
#define	DBR_OS_GETSTART	0x080	/* Start of O.S. get calls */
#define	DBR_OS_PUTSTART	0x180	/* Start of O.S. put calls */

/*
 * Acknowledgements
 */
#define	DBA_NULL	0
#define	DBA_OK		1
#define	DBA_BAD		2
#define	DBA_UNSUPPORT	3
#define	DBA_KSTOPPED	4	/* Can't debug OS process if kernel stopped */
#define	DBA_BUSERR	5	/* Buserr during READ or WRITE */
#define	DBA_TIMEOUT	6	/* Protocol time out */

/*
 * Configuration structure returned by DBR_GETATTRIB
 */
struct DebugAttrib {
	short	machine;		/* Processor type */
#define		DBMT_UNKNOWN	0
#define		DBMT_68000	1
#define		DBMT_68010	2
#define		DBMT_68020	3
#define		DBMT_32100	4
#define		DBMT_DSP32	5
#define		DBMT_DSP32C	6
#define		DBMT_SPARC	7
#define		DBMT_MIPSR3000	8
#define		DBMT_I386	9
	short	fp;			/* Floating point */
#define		DBFP_NONE	0
#define		DBFP_68881	1
#define		DBFP_SKY	2
	short	os;			/* Operating system */
#define		DBOS_RAW	0	/* Running on a raw board */
#define		DBOS_UNIX	1
#define		DBOS_NRTX	2
	short	pad;			/* Pad to longword boundry */
};

/*
 * State of the kernel
 */
struct DebugKstate {
	short	state;
#define		DBKS_NULL	0	/* No process has been loaded */
#define		DBKS_RUNNING	1
#define		DBKS_STOPPED	2
#define		DBKS_ERROR	3
	short	code;
#define		DBKC_TRAP	0	/* Breakpoint or traced */
#define		DBKC_STOP	1	/* Stopped */
};

/*
 * Board specific interrupt vectors used by monitor
 */
struct DebugVector {
	long	vec;
	void	(*routine)();
};

/*
 * Used by operating systems and remote processors to integrate
 * debug requests with the kernel debug monitor
 */
struct DebugInterface {
 struct	DebugRequest	req;	/* on board address */
 long	busy;			/* Set if debug request in progress */
#define		DBBUSY_KERNEL	1	/* Kernel active */
#define		DBBUSY_OS	2	/* Operating system active */
#define		DBBUSY_REM	3	/* Remote processor active */
 struct	DebugRegs	*reg;	/* Registers */
 struct DebugKstate	state;	/* State of the machine */
 struct DebugAttrib	conf;	/* Board configuration attributes */
 struct DebugVector	*vec;	/* Interrupt vector table */
 void	(*montrap)();		/* Monitor trap handler */
 void	(*monreq)();		/* Monitor reqest handler */
 void	(*monreply)();		/* Monitor reply to debug requests */
 void	(*iosnd)();		/* IO send reply */
 void	(*iopoll)();		/* IO poll for input routine */
 long	iolevel;		/* Level of I/O interrupts */
 void	(*osstart)();		/* OS kernel debug start routine */
 void	(*osdone)();		/* OS kernel debug finish routine */
 void	(*osreq)();		/* OS request handler */
 void	(*remreq)();		/* Remote processor request handler */
 void	(*remreply)();		/* Remote processor reply to debug requests */
 void	(*rempoll)();		/* Remote processor poll for ack routine */
 long	remlevel;		/* Level of remote processor interrupts */
 void	(*localreq)();		/* Local request handler */
 char	*bdname;		/* Symbolic name of the board */
 long	bdnsz;			/* Number of characters in name */
 long	nproc;			/* Number of processors */
 long	scratchaddr;		/* Area to interpret function calls */
 long	ramaddr;		/* Start address of ram used by monitor */
 long	ramsize;		/* Length of ram used by monitor */
 long	local[5];		/* Implementation dependent */
 short	procid;			/* Processor id of board */
 short	pad;			/* Keep long word alignment */
};

/*
 * Target word orders - needed for conversions between host and target
 */
#define	DBWO_MSBFIRST	0	/* 68K, 32100, Mips, Sparc */
#define	DBWO_LSBFIRST	1	/* DSP32C, 386 */
